// |x̖{̃NXAWikipediap
#include "stdafx.h"
#include "TranslateWikipedia.h"

using namespace wpts;

/* |xs̖{ */
bool TranslateWikipedia::runBody(String ^i_Name)
{
	System::Diagnostics::Debug::WriteLine("\nTranslateWikipedia::runBody > " + i_Name);
	// ΏۋL擾
	WikipediaArticle ^article = chkTargetArticle(i_Name);
	if(article->Text == ""){
		return false;
	}
	// ΏۋLɌԃN݂ꍇAp邩mF
	String ^interWiki = article->GetInterWiki(target->Code);
	if(interWiki != ""){
		if(MessageBox::Show(
				String::Format(cmnAP->Resource->GetString("QuestionMessage_ArticleExist"), interWiki),
				cmnAP->Resource->GetString("QuestionTitle"),
				MessageBoxButtons::YesNo,
				MessageBoxIcon::Question)
		   == System::Windows::Forms::DialogResult::No){
			logLine(ENTER + String::Format(cmnAP->Resource->GetString("QuestionMessage_ArticleExist"), interWiki));
			return false;
		}
		else{
			logLine(" " + String::Format(cmnAP->Resource->GetString("LogMessage_ArticleExistInterWiki"), interWiki));
		}
	}

	// `쐬
	Text += "'''xxx'''";
	String ^bracket = static_cast<WikipediaInformation^>(target)->Bracket;
	if(bracket->Contains("{0}") == true){
		String ^originalName = "";
		String ^langTitle = static_cast<WikipediaInformation^>(source)->GetFullName(target->Code);
		if(langTitle != ""){
			originalName = "[[" + langTitle + "]]: ";
		}
		Text += String::Format(bracket, originalName + "'''" + i_Name + "'''");
	}
	Text += "\n\n";
	// ԃNE^̕ϊ
	logLine(ENTER + " " + String::Format(cmnAP->Resource->GetString("LogMessage_CheckAndReplaceStart"), interWiki));
	Text += replaceText(article->Text, article->Title);
	// [U[̒~v`FbN
	if(CancellationPending){
		return false;
	}
	// VԃNƁARgǋL
	Text += ("\n\n[[" + source->Code + ":" + i_Name + "]]\n");
	Text += (String::Format(cmnAP->Resource->GetString("ArticleFooter"), MYAPP::Cmn::GetProductName(),
		source->Code, i_Name, article->Timestamp.ToString("U")) + "\n");
	// _E[heLXgLFȂ̂ŁAőSCRLFɕϊ
	// _E[hCRLFɂ悤Ȏdg݂΁Ag
	//   ̏ꍇÂ悤\nׂɓfĂ镔C
	Text = Text->Replace("\n", const_cast<String^>(ENTER));

	System::Diagnostics::Debug::WriteLine("TranslateWikipedia::runBody > Success!");
	return true;
}

/* |xΏۂ̋L擾 */
WikipediaArticle^ TranslateWikipedia::chkTargetArticle(String ^i_Name)
{
	// w肳ꂽL̐f[^Wikipedia擾
	logLine(String::Format(cmnAP->Resource->GetString("LogMessage_GetArticle"), "http://" + static_cast<WikipediaInformation^>(source)->Server, i_Name));
	WikipediaArticle ^article = gcnew WikipediaArticle(static_cast<WikipediaInformation^>(source), i_Name);
	if(article->GetArticle(UserAgent, Referer, TimeSpan(0)) == false){
		if(article->GetArticleStatus == HttpStatusCode::NotFound){
			logLine(" " + cmnAP->Resource->GetString("LogMessage_ArticleNothing"));
		}
		else{
			logLine(" " + article->GetArticleException->Message);
			logLine(" " + String::Format(cmnAP->Resource->GetString("LogMessage_ErrorURL"), article->Url));
		}
	}
	else{
		// Wikipediaւ̏ANZXɁAOԏ擾
		static_cast<WikipediaInformation^>(source)->Namespaces = article->GetNamespaces();
		// _CNg`FbNA_CNgł΁A̐̋L擾
		if(article->IsRedirect()){
			logLine(" " + cmnAP->Resource->GetString("LogMessage_Redirect") + " [[" + article->Redirect + "]]");
			article = gcnew WikipediaArticle(static_cast<WikipediaInformation^>(source), article->Redirect);
			if(article->GetArticle(UserAgent, Referer, TimeSpan(0)) == false){
				if(article->GetArticleStatus == HttpStatusCode::NotFound){
					logLine(" " + cmnAP->Resource->GetString("LogMessage_ArticleNothing"));
				}
				else{
					logLine(" " + article->GetArticleException->Message);
					logLine(" " + String::Format(cmnAP->Resource->GetString("LogMessage_ErrorURL"), article->Url));
				}
			}
		}
	}
	return article;
}

/* w肳ꂽL擾AԃNmFAԂ */
String^ TranslateWikipedia::getInterWiki(String ^i_Name, bool i_TemplateFlag)
{
	// w肳ꂽL̐f[^Wikipedia擾
	// L݂̂ȂꍇANULLԂ
	String ^interWiki = nullptr;
	String ^name = i_Name;
	if(!i_TemplateFlag){
		Log += "[[" + name + "]]  ";
	}
	else{
		Log += "{{" + name + "}}  ";
	}
	WikipediaArticle ^article = gcnew WikipediaArticle(static_cast<WikipediaInformation^>(source), i_Name);
	if(article->GetArticle(UserAgent, Referer) == false){
		if(article->GetArticleStatus == HttpStatusCode::NotFound){
			Log += cmnAP->Resource->GetString("LogMessage_LinkArticleNothing");
		}
		else{
			logLine(" " + article->GetArticleException->Message);
			logLine(" " + String::Format(cmnAP->Resource->GetString("LogMessage_ErrorURL"), article->Url));
		}
	}
	else{
		// _CNg`FbNA_CNgł΁A̐̋L擾
		if(article->IsRedirect()){
			Log += (cmnAP->Resource->GetString("LogMessage_Redirect") + " [[" + article->Redirect + "]]  ");
			article = gcnew WikipediaArticle(static_cast<WikipediaInformation^>(source), article->Redirect);
			if(article->GetArticle(UserAgent, Referer) == false){
				if(article->GetArticleStatus == HttpStatusCode::NotFound){
					logLine(" " + cmnAP->Resource->GetString("LogMessage_ArticleNothing"));
				}
				else{
					logLine(" " + article->GetArticleException->Message);
					logLine(" " + String::Format(cmnAP->Resource->GetString("LogMessage_ErrorURL"), article->Url));
				}
			}
		}
		if(article->Text != ""){
			// |挾ւ̌ԃN{
			interWiki = article->GetInterWiki(target->Code);
			if(interWiki != ""){
				Log += ("[[" + interWiki + "]]");
			}
			else{
				Log += cmnAP->Resource->GetString("LogMessage_InterWikiNothing");
			}
		}
	}
	// so͂ĂȂꍇi펞jAs
	if(Log->EndsWith(const_cast<String^>(ENTER)) == false){
		Log += ENTER;
	}
	return interWiki;
}

/* w肳ꂽL擾AԃNmFAԂiev[gȊOj */
String^ TranslateWikipedia::getInterWiki(String ^i_Name)
{
	return getInterWiki(i_Name, false);
}

// nꂽeLXg͂AԃNEo̕ϊs
String^ TranslateWikipedia::replaceText(String ^i_Text, String ^i_Parent, bool i_TitleFlag)
{
	// w肳ꂽĽԃNEoTA|挾ł̖̂ɕϊAɒuԂ
	String ^result = "";
	bool enterFlag = true;
	WikipediaFormat wikiAP(static_cast<WikipediaInformation^>(source));
	for(int i = 0 ; i < i_Text->Length ; i++){
		// [U[̒~v`FbN
		if(CancellationPending == true){
			break;
		}
		wchar_t c = i_Text[i];
		// oΏۂ̏ꍇ
		if(i_TitleFlag){
			// s̏ꍇÃ[vŌos`FbNs
			if(c == '\n'){
				enterFlag = true;
				result += c;
				continue;
			}
			// s̎n߂ł́A̍so̍s̃`FbNs
			if(enterFlag){
				String ^newTitleLine = "";
				int index = chkTitleLine(newTitleLine, i_Text, i);
				if(index != -1){
					// s̏I܂ŃCfbNXړ
					i = index;
					// uꂽoso
					result += newTitleLine;
					continue;
				}
				else{
					enterFlag = false;
				}
			}
		}
		// Rgi<!--j̃`FbN
		String ^comment = "";
		int index = WikipediaFormat::ChkComment(comment, i_Text, i);
		if(index != -1){
			i = index;
			result += comment;
			if(comment->Contains("\n") == true){
				enterFlag = true;
			}
			continue;
		}
		// nowikĩ`FbN
		String ^nowiki = "";
		index = WikipediaFormat::ChkNowiki(nowiki, i_Text, i);
		if(index != -1){
			i = index;
			result += nowiki;
			continue;
		}
		// ϐi{{{1}}}Ƃj̃`FbN
		String ^variable = "";
		String ^value = "";
		index = wikiAP.ChkVariable(variable, value, i_Text, i);
		if(index != -1){
			i = index;
			// ϐ | ȍ~ɒlLqĂꍇAɑ΂čċAIɏs
			int valueIndex = variable->IndexOf('|');
			if(valueIndex != -1 && !String::IsNullOrEmpty(value)){
				variable = (variable->Substring(0, valueIndex + 1) + replaceText(value, i_Parent) + "}}}");
			}
			result += variable;
			continue;
		}
		// NEev[g̃`FbNϊAԃN擾o͂
		String ^text = "";
		index = replaceLink(text, i_Text, i, i_Parent);
		if(index != -1){
			i = index;
			result += text;
			continue;
		}
		// ʏ͂̂܂܃Rs[
		result += i_Text[i];
	}
	return result;
}

// nꂽeLXg͂AԃNEo̕ϊs
String^ TranslateWikipedia::replaceText(String ^i_Text, String ^i_Parent)
{
	return replaceText(i_Text, i_Parent, true);
}

// N̉́Eus
int TranslateWikipedia::replaceLink(String ^%o_Link, String ^i_Text, int i_Index, String ^i_Parent)
{
	// o͒l
	int lastIndex = -1;
	o_Link = "";
	WikipediaFormat::Link link;
	// NEev[g̊mFƉ
	WikipediaFormat wikiAP(static_cast<WikipediaInformation^>(source));
	lastIndex = wikiAP.ChkLinkText(link, i_Text, i_Index);
	if(lastIndex != -1){
		// LɕϐgĂꍇ̂ŁÃ`FbNƓWJ
		int index = link.Article->IndexOf("{{{");
		if(index != -1){
			String ^variable = "";
			String ^value = "";
			int lastIndex = wikiAP.ChkVariable(variable, value, link.Article, index);
			if(lastIndex != -1 && !String::IsNullOrEmpty(value)){
				// ϐ | ȍ~ɒlLqĂꍇAɒu
				String ^newArticle = (link.Article->Substring(0, index) + value);
				if(lastIndex + 1 < link.Article->Length){
					newArticle += link.Article->Substring(lastIndex + 1);
				}
				link.Article = newArticle;
			}
			// lݒ肳ĂȂꍇAĂ傤Ȃ̂ŁAO
			else{
				System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceLink > ΏۊO : " + link.Text);
				return -1;
			}
		}

		String ^newText = nullptr;
		// N̏ꍇ
		if(i_Text[i_Index] == '['){
			// N̕ϊ㕶擾
			newText = replaceInnerLink(link, i_Parent);
		}
		// ev[g̏ꍇ
		else if(i_Text[i_Index] == '{'){
			// ev[g̕ϊ㕶擾
			newText = replaceTemplate(link, i_Parent);
		}
		// LȊȌꍇ́AΏۊO
		else{
			System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceLink > vO~X : " + link.Text);
		}
		// ϊ㕶NULLȊO
		if(newText != nullptr){
			o_Link = newText;
		}
		else{
			lastIndex = -1;
		}
	}
	return lastIndex;
}

// N̕ϊ
String^ TranslateWikipedia::replaceInnerLink(WikipediaFormat::Link i_Link, String ^i_Parent)
{
	// ϐݒ
	String ^result = "[[";
	String ^comment = "";
	WikipediaFormat::Link link = i_Link;
	// LwĂꍇi[[#֘A]]ƂjȊO
	if(!String::IsNullOrEmpty(link.Article) &&
	   !(link.Article == i_Parent && String::IsNullOrEmpty(link.Code) && !String::IsNullOrEmpty(link.Section))){
		// ϊ̑ΏۊOƂ郊N`FbN
		WikipediaArticle article(static_cast<WikipediaInformation^>(source), link.Article);
		// Tuy[W̏ꍇALU
		if(link.SubPageFlag){
			link.Article = i_Parent + link.Article;
		}
		// ԃNEovWFNgւ̃NE摜͑ΏۊO
		else if(!String::IsNullOrEmpty(link.Code) || article.IsImage()){
			result = "";
			// 擪 : łȂA|挾ւ̌ԃN̏ꍇ
			if(!link.StartColonFlag && link.Code == target->Code){
				// 폜BIŁAu㕶ȂԂ
				System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceInnerLink > " + link.Text + " 폜");
				return "";
			}
			// ȊO͑ΏۊO
			System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceInnerLink > ΏۊO : " + link.Text);
			return nullptr;
		}
		// NHAΏۋĽԃN擾
		String ^interWiki = getInterWiki(link.Article);
		// L݂̂ȂiԃNjꍇAN͂̂܂
		if(interWiki == nullptr){
			result += link.Article;
		}
		// ԃN݂ȂꍇA[[:en:xxx]]݂Ȍ`ɒu
		else if(interWiki == ""){
			result += (":" + source->Code + ":" + link.Article);
		}
		// ԃN݂ꍇAw悤ɒu
		else{
			// O̕𕜌
			if(link.SubPageFlag){
				int index = interWiki->IndexOf('/');
				if(index == -1){
					index = 0;
				}
				result += interWiki->Substring(index);
			}
			else if(link.StartColonFlag){
				result += (":" + interWiki);
			}
			else{
				result += interWiki;
			}
		}
		// JeS[̏ꍇ́ARgŌ̕ǉ
		if(article.IsCategory() && !link.StartColonFlag){
			comment = (WikipediaFormat::COMMENTSTART + " " + link.Text + " " + WikipediaFormat::COMMENTEND);
			// JeS[[[:en:xxx]]݂Ȍ`ɂꍇA| ȍ~͕svȂ̂ō폜
			if(interWiki == ""){
				link.PipeTexts = gcnew array<String^>(0);
			}
		}
		// \݂ȂꍇA̖O\ɐݒ
		else if(link.PipeTexts->Length == 0 && interWiki != nullptr){
			MYAPP::Cmn::AddArray(link.PipeTexts, article.Title);
		}
	}
	// oi[[#֘A]]Ƃjo
	if(!String::IsNullOrEmpty(link.Section)){
		// óA^ϊʂ
		result += ("#" + getKeyWord(link.Section));
	}
	// \o
	for each(String ^text in link.PipeTexts){
		result += "|";
		if(!String::IsNullOrEmpty(text)){
			// 摜̏ꍇA| ̌ɓNev[gĂꍇ邪A
			// 摜͏ΏۊOł肻̒̃N͌ʂɍēx邽߁Ał͓ɉȂ
			result += text;
		}
	}
	// N
	result += "]]";
	// Rgt
	if(comment != ""){
		result += comment;
	}
	System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceInnerLink > " + link.Text);
	return result;
}

// ev[g̕ϊ
String^ TranslateWikipedia::replaceTemplate(WikipediaFormat::Link i_Link, String ^i_Parent)
{
	// ϐݒ
	String ^result = "";
	String ^comment = "";
	WikipediaFormat::Link link = i_Link;
	// ev[g͋LK{
	if(String::IsNullOrEmpty(link.Article)){
		System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceTemplate > ΏۊO : " + link.Text);
		return nullptr;
	}
	// VXeϐ̏ꍇ͑ΏۊO
	if(static_cast<WikipediaInformation^>(source)->ChkSystemVariable(link.Article) == true){
		System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceTemplate > VXeϐ : " + link.Text);
		return nullptr;
	}
	// ev[gOԂAʂ̋L𔻒
	if(!link.StartColonFlag && !link.SubPageFlag){
		String ^templateStr = static_cast<WikipediaInformation^>(source)->GetNamespace(static_cast<WikipediaInformation^>(source)->TEMPLATENAMESPACENUMBER);
		if(templateStr != "" && !link.Article->StartsWith(templateStr + ":")){
			WikipediaArticle article(static_cast<WikipediaInformation^>(source), templateStr + ":" + link.Article);
			// L݂ꍇAev[gOŎ擾
			if(article.GetArticle(UserAgent, Referer) == true){
				link.Article = article.Title;
			}
			// L擾łȂꍇA404łȂꍇ݂͑Ƃď
			else if(article.GetArticleStatus != HttpStatusCode::NotFound){
				logLine(String::Format(cmnAP->Resource->GetString("LogMessage_TemplateUnknown"), link.Article, templateStr, article.GetArticleException->Message));
				link.Article = article.Title;
			}
		}
	}
	// Tuy[W̏ꍇALU
	else if(link.SubPageFlag){
		link.Article = i_Parent + link.Article;
	}
	// NHAΏۋĽԃN擾
	String ^interWiki = getInterWiki(link.Article, true);
	// L݂̂ȂiԃNjꍇAN͂̂܂
	if(interWiki == nullptr){
		result += link.Text;
	}
	// ԃN݂ȂꍇA[[:en:Template:xxx]]݂ȕʂ̃Nɒu
	else if(interWiki == ""){
		// ܂ŁÃev[g̏ԂRgł
		result += ("[[:" + source->Code + ":" + link.Article + "]]" + WikipediaFormat::COMMENTSTART + " " + link.Text + " " + WikipediaFormat::COMMENTEND);
	}
	// ԃN݂ꍇAw悤ɒu
	else{
		result += "{{";
		// O̕𕜌
		if(link.StartColonFlag){
			result += ":";
		}
		if(link.MsgnwFlag){
			result += WikipediaFormat::MSGNW;
		}
		// : O̕폜ďói: Ƃ-1+10j
		result += interWiki->Substring(interWiki->IndexOf(':') + 1);
		// s𕜌
		if(link.EnterFlag){
			result += "\n";
		}
		// | ̌t
		for each(String ^text in link.PipeTexts){
			result += "|";
			if(!String::IsNullOrEmpty(text)){
				// | ̌ɓNev[gĂꍇ̂ŁAċAIɏ
				result += replaceText(text, i_Parent);
			}
		}
		// N
		result += "}}";
	}
	System::Diagnostics::Debug::WriteLine("TranslateWikipedia::replaceTemplate > " + link.Text);
	return result;
}

/* w肳ꂽCfbNẌʒuɑ݂錩o(==֘A==݂Ȃ)͂A\łΕϊĕԂ */
int TranslateWikipedia::chkTitleLine(String ^%o_Title, String ^i_Text, int i_Index)
{
	// 
	// oł͂ȂA\Ȃǂ̏ꍇA-1Ԃ
	int lastIndex = -1;
	o_Title = "";
/*	// ͒lmFAt@C̐擪A܂͉s==Ŏn܂Ă邩`FbN
	// RgƂlƃŶŁA==`FbNāA͌Ăяoōs
	if(i_Index != 0){
		if((MYAPP::Cmn::ChkTextInnerWith(i_Text, i_Index - 1, "\n==") == false){
			return lastIndex;
		}
	}
	else if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i_Index, "==") == false){
		return lastIndex;
	}
*/	// \͂āA1s̕ƁA=̌擾
	// \Wikipediãvr[ŐFXĊmFAȂԈĂ肷邩EEE
	// Wikipediał <!--test-->=<!--test-->=֘A<!--test-->==<!--test--> ݂Ȃ̂ł
	//   ɔF̂ŁAł邾Ή
	// ϊɍsꂽꍇARg͍폜
	bool startFlag = true;
	int startSignCounter = 0;
	String ^nonCommentLine = "";
	for(lastIndex = i_Index ; lastIndex < i_Text->Length ; lastIndex++){
		wchar_t c = i_Text[lastIndex];
		// s܂
		if(c == '\n'){
			break;
		}
		// Rg͖
		String ^comment = "";
		int index = WikipediaArticle::ChkComment(comment, i_Text, lastIndex);
		if(index != -1){
			o_Title += comment;
			lastIndex = index;
			continue;
		}
		// 擪̏ꍇA=̐𐔂
		else if(startFlag){
			if(c == '='){
				++startSignCounter;
			}
			else{
				startFlag = false;
			}
		}
		nonCommentLine += c;
		o_Title += c;
	}
	// sA܂͕͂̍Ō+1ɂȂĂ͂Ȃ̂ŁA1߂
	--lastIndex;
	// = Ŏn܂sł͂ȂꍇAΏۊO
	if(startSignCounter < 1){
		o_Title = "";
		return -1;
	}
	// I = ̐mF
	// ̏ƒg̖si====Ƃj͒eĂ܂AǂłȂ̂ŋe
	int endSignCounter = 0;
	for(int i = nonCommentLine->Length - 1 ; i >= startSignCounter ; i--){
		if(nonCommentLine[i] == '='){
			++endSignCounter;
		}
		else{
			break;
		}
	}
	// = ŏIsł͂ȂꍇAΏۊO
	if(endSignCounter < 1){
		o_Title = "";
		return -1;
	}
	// n܂ƏIA=̏Ȃقɂ킹i==test===Ƃp̏j
	int signCounter = startSignCounter;
	if(startSignCounter > endSignCounter){
		signCounter = endSignCounter;
	}
	// ^ϊ
	String ^oldText = nonCommentLine->Substring(signCounter, nonCommentLine->Length - (signCounter * 2))->Trim();
	String ^newText = getKeyWord(oldText);
	if(oldText != newText){
		String ^sign = "=";
		for(int i = 1 ; i < signCounter ; i++){
			sign += "=";
		}
		String ^newTitle = (sign + newText + sign);
		logLine(ENTER + o_Title + "  " + newTitle);
		o_Title = newTitle;
	}
	else{
		logLine(ENTER + o_Title);
	}
	return lastIndex;
}

/* w肳ꂽR[hł̒^ɑAʂ̌ł̒^擾 */
String^ TranslateWikipedia::getKeyWord(String ^i_Key)
{
	// ݒ肪݂ȂꍇA͒^̂܂܂Ԃ
	String ^key = ((i_Key != nullptr) ? i_Key : "");
	WikipediaInformation^ src = static_cast<WikipediaInformation^>(source);
	WikipediaInformation^ tar = static_cast<WikipediaInformation^>(target);
	if(key->Trim() == ""){
		return key;
	}
	for(int i = 0 ; i < src->TitleKeys->Length ; i++){
		if(src->TitleKeys[i]->ToLower() == key->Trim()->ToLower()){
			if(tar->TitleKeys->Length > i){
				if(tar->TitleKeys[i] != ""){
					key = tar->TitleKeys[i];
				}
				break;
			}
		}
	}
	return key;
}
